<?php

namespace App\Filament\Resources\OrderResource\Pages;

use App\Filament\Resources\OrderResource;
use Filament\Actions;
use Filament\Resources\Pages\ListRecords;
use Filament\Resources\Components\Tab;
use Illuminate\Database\Eloquent\Builder;
use App\Models\Order;
use App\Services\OrderStatusService;

class ListOrders extends ListRecords
{
    protected static string $resource = OrderResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Actions\CreateAction::make(),
        ];
    }

    public function getTabs(): array
    {
        return [
            'unpaid' => Tab::make('Belum Bayar')
                ->icon('heroicon-o-credit-card')
                ->badge(fn (): int => Order::where('status', 'pending')->count())
                ->badgeColor('gray')
                ->modifyQueryUsing(fn (Builder $query): Builder => 
                    $query->where('status', 'pending')
                ),
            
            'perlu_diproses' => Tab::make('Menunggu Konfirmasi')
                ->icon('heroicon-o-exclamation-triangle')
                ->badge(fn (): int => Order::where('status', 'awaiting_confirmation')->count())
                ->badgeColor('warning')
                ->modifyQueryUsing(fn (Builder $query): Builder => 
                    $query->where('status', 'awaiting_confirmation')
                ),
            
            'preparing' => Tab::make('Diproses')
                ->icon('heroicon-o-cube')
                ->badge(fn (): int => Order::where('status', 'processing')->count())
                ->badgeColor('info')
                ->modifyQueryUsing(fn (Builder $query): Builder => 
                    $query->where('status', 'processing')
                ),
            
            'transit' => Tab::make('Dalam Pengiriman')
                ->icon('heroicon-o-truck')
                ->badge(fn (): int => Order::where('status', 'shipped')->count())
                ->badgeColor('primary')
                ->modifyQueryUsing(fn (Builder $query): Builder => 
                    $query->where('status', 'shipped')
                ),
            
            'delivered' => Tab::make('Terkirim')
                ->icon('heroicon-o-check-circle')
                ->badge(fn (): int => Order::where('status', 'completed')->count())
                ->badgeColor('success')
                ->modifyQueryUsing(fn (Builder $query): Builder => 
                    $query->where('status', 'completed')
                ),
            
            'cancelled' => Tab::make('Dibatalkan')
                ->icon('heroicon-o-x-circle')
                ->badge(fn (): int => Order::where('status', 'cancelled')->count())
                ->badgeColor('danger')
                ->modifyQueryUsing(fn (Builder $query): Builder => 
                    $query->where('status', 'cancelled')
                ),
        ];
    }
}
