<?php

namespace App\Providers;

use App\Models\Order;
use App\Models\OrderItem;
use App\Models\Setting;
use App\Models\Store;
use App\Observers\OrderItemObserver;
use App\Observers\OrderObserver;
use Illuminate\Auth\Notifications\ResetPassword;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Facades\View;
use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        // Fix MySQL/MariaDB "Specified key was too long" for indexed VARCHAR columns.
        Schema::defaultStringLength(191); // [web:32][web:18]

        // Load email settings from database (skip when tables not ready / during migration)
        try {
            if (Schema::hasTable('settings')) {
                $settings = Setting::query()->pluck('value', 'key')->toArray();

                $emailEnabled = ($settings['email_notifications_enabled'] ?? 'false') === 'true';

                if ($emailEnabled && !empty($settings['mail_host'] ?? null)) {
                    Config::set('mail.mailers.smtp.host', $settings['mail_host']);
                    Config::set('mail.mailers.smtp.port', $settings['mail_port'] ?? '587');
                    Config::set('mail.mailers.smtp.username', $settings['mail_username'] ?? null);
                    Config::set('mail.mailers.smtp.password', $settings['mail_password'] ?? null);
                    Config::set('mail.mailers.smtp.encryption', $settings['mail_encryption'] ?? 'tls');
                    Config::set('mail.from.address', $settings['mail_from_address'] ?? null);
                    Config::set('mail.from.name', $settings['mail_from_name'] ?? null);
                }
            }
        } catch (\Throwable $e) {
            // Database might not be ready (e.g., during migration). Skip loading settings.
        }

        if ($this->app->environment('production')) {
            URL::forceScheme('https');
        }

        // Share store data to all views (skip when table not ready)
        View::composer('*', function ($view) {
            try {
                if (Schema::hasTable('stores')) {
                    $view->with('store', Store::query()->first());
                }
            } catch (\Throwable $e) {
                // ignore
            }
        });

        OrderItem::observe(OrderItemObserver::class);
        Order::observe(OrderObserver::class);

        // (Opsional) kalau kamu override link reset password:
        // ResetPassword::createUrlUsing(function ($notifiable, string $token) {
        //     return url(route('password.reset', ['token' => $token, 'email' => $notifiable->getEmailForPasswordReset()], false));
        // });
    }
}
