<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Create variant types table
        Schema::create('variant_types', function (Blueprint $table) {
            $table->id();
            $table->string('name', 191)->unique(); // 191 biar aman untuk index utf8mb4
            $table->timestamps();
        });

        // Create variant options table
        Schema::create('variant_options', function (Blueprint $table) {
            $table->id();
            $table->foreignId('variant_type_id')->constrained()->onDelete('cascade');

            // Batasi jadi 191 karena ikut unique composite di bawah
            $table->string('name', 191);

            $table->timestamps();

            // Each option name should be unique within its type
            $table->unique(['variant_type_id', 'name'], 'var_opt_type_name_unique');
        });

        // Create product variants table
        Schema::create('product_variants', function (Blueprint $table) {
            $table->id();
            $table->foreignId('product_id')->constrained()->onDelete('cascade');

            // Batasi string yang berpotensi ikut index / unique
            $table->string('variant_type1', 191)->nullable()->comment('Jenis varian pertama (misalnya: Ukuran)');
            $table->string('variant_option1', 191)->nullable()->comment('Opsi varian pertama (misalnya: L)');
            $table->string('variant_type2', 191)->nullable()->comment('Jenis varian kedua (misalnya: Warna)');
            $table->string('variant_option2', 191)->nullable()->comment('Opsi varian kedua (misalnya: Merah)');

            $table->string('sku', 191)->unique(); // aman juga untuk index
            $table->decimal('price', 10, 2);
            $table->integer('stock')->default(0);
            $table->boolean('is_active')->default(true);
            $table->timestamps();

            // Memastikan kombinasi varian unik untuk setiap produk
            $table->unique(
                ['product_id', 'variant_option1', 'variant_option2'],
                'unique_variant_combination'
            );
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // urutan drop: tabel anak dulu, baru parent
        Schema::dropIfExists('product_variants');
        Schema::dropIfExists('variant_options');
        Schema::dropIfExists('variant_types');
    }
};
