<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('products', function (Blueprint $table) {
            // Add is_product_digital column
            $table->boolean('is_product_digital')->default(false)->after('is_active');
            
            // Make physical dimension columns nullable for digital products
            $table->decimal('weight', 10, 2)->nullable()->change();
            $table->decimal('height', 10, 2)->nullable()->change();
            $table->decimal('width', 10, 2)->nullable()->change();
            $table->decimal('length', 10, 2)->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('products', function (Blueprint $table) {
            // Remove is_product_digital column
            $table->dropColumn('is_product_digital');
            
            // Revert physical dimension columns to not nullable with defaults
            $table->decimal('weight', 10, 2)->default(0)->change();
            $table->decimal('height', 10, 2)->default(0)->change();
            $table->decimal('width', 10, 2)->default(0)->change();
            $table->decimal('length', 10, 2)->default(0)->change();
        });
    }
};
