<!-- Bottom Navigation -->
<nav class="fixed bottom-0 left-1/2 -translate-x-1/2 w-full max-w-[480px] md:max-w-full md:w-full md:left-0 md:translate-x-0 md:top-0 md:bottom-auto bg-white border-t md:border-t-0 md:border-b border-gray-200 h-[70px] z-50 md:shadow-md md:backdrop-blur-sm md:bg-white/95">
    <!-- Mobile Grid -->
    <div class="grid h-full grid-cols-4 md:hidden">
        <a href="{{route('home')}}"
           wire:click="setActiveMenu('home')"
           class="flex flex-col items-center justify-center {{ $activeMenu === 'home' ? 'text-primary' : 'text-gray-500 hover:text-primary'}}">
            <i class="bi bi-house text-2xl mb-0.5"></i>
            <span class="text-xs">Beranda</span>
        </a>
        <a href="{{route('shopping-cart')}}"
           wire:click="setActiveMenu('shopping-cart')"
           class="flex flex-col items-center justify-center {{ $activeMenu === 'shopping-cart' ? 'text-primary' : 'text-gray-500 hover:text-primary'}} transition-colors">
            <i class="bi bi-bag text-2xl mb-0.5"></i>
            <span class="text-xs">Keranjang</span>
        </a>
        <a href="{{route('orders')}}"
           wire:click="setActiveMenu('orders')"
           class="flex flex-col items-center justify-center {{ $activeMenu === 'orders' ? 'text-primary' : 'text-gray-500 hover:text-primary'}} transition-colors">
            <i class="bi bi-receipt text-2xl mb-0.5"></i>
            <span class="text-xs">Pesanan</span>
        </a>
        <a href="{{route('profile')}}"
           wire:click="setActiveMenu('profile')"
           class="flex flex-col items-center justify-center {{ $activeMenu === 'profile' ? 'text-primary' : 'text-gray-500 hover:text-primary'}} transition-colors">
            <i class="bi bi-person text-2xl mb-0.5"></i>
            <span class="text-xs">Akun</span>
        </a>
    </div>

    <!-- Desktop Menu - SEJAUH ATAS DENGAN TAILWIND SAJA -->
    <div class="hidden md:flex h-full px-8 lg:px-12 xl:px-16 items-start justify-between pt-1">
        <!-- Logo KIRI -->
        <a href="{{route('home')}}" class="flex pt-1 group hover:scale-105 transition-transform">
            <img src="{{ asset('image/store-2.jpg') }}" 
                 alt="Shadow Exhaust System" 
                 class="h-8 w-auto drop-shadow-md hover:drop-shadow-xl object-contain">
        </a>

        <!-- Menu KANAN -->
        <div class="flex items-start gap-1 pt-1">
            <a href="{{route('home')}}"
               wire:click="setActiveMenu('home')"
               class="relative px-3 py-2 rounded-lg font-medium transition-all {{ $activeMenu === 'home' ? 'text-primary bg-primary/10' : 'text-gray-600 hover:text-primary hover:bg-gray-50'}}">
                <span class="flex items-center gap-1.5 text-sm">
                    <i class="bi bi-house-door"></i>
                    Beranda
                </span>
                @if($activeMenu === 'home')
                    <span class="absolute -bottom-1 left-1/2 -translate-x-1/2 w-4 h-0.5 bg-primary rounded-full"></span>
                @endif
            </a>
            <a href="{{route('shopping-cart')}}"
               wire:click="setActiveMenu('shopping-cart')"
               class="relative px-3 py-2 rounded-lg font-medium transition-all {{ $activeMenu === 'shopping-cart' ? 'text-primary bg-primary/10' : 'text-gray-600 hover:text-primary hover:bg-gray-50'}}">
                <span class="flex items-center gap-1.5 text-sm">
                    <i class="bi bi-cart3"></i>
                    Keranjang
                </span>
                @if($activeMenu === 'shopping-cart')
                    <span class="absolute -bottom-1 left-1/2 -translate-x-1/2 w-4 h-0.5 bg-primary rounded-full"></span>
                @endif
            </a>
            <a href="{{route('orders')}}"
               wire:click="setActiveMenu('orders')"
               class="relative px-3 py-2 rounded-lg font-medium transition-all {{ $activeMenu === 'orders' ? 'text-primary bg-primary/10' : 'text-gray-600 hover:text-primary hover:bg-gray-50'}}">
                <span class="flex items-center gap-1.5 text-sm">
                    <i class="bi bi-receipt"></i>
                    Pesanan
                </span>
                @if($activeMenu === 'orders')
                    <span class="absolute -bottom-1 left-1/2 -translate-x-1/2 w-4 h-0.5 bg-primary rounded-full"></span>
                @endif
            </a>
            <a href="{{route('profile')}}"
               wire:click="setActiveMenu('profile')"
               class="relative px-3 py-2 rounded-lg font-medium transition-all {{ $activeMenu === 'profile' ? 'text-primary bg-primary/10' : 'text-gray-600 hover:text-primary hover:bg-gray-50'}}">
                <span class="flex items-center gap-1.5 text-sm">
                    <i class="bi bi-person-circle"></i>
                    Akun Saya
                </span>
                @if($activeMenu === 'profile')
                    <span class="absolute -bottom-1 left-1/2 -translate-x-1/2 w-4 h-0.5 bg-primary rounded-full"></span>
                @endif
            </a>
        </div>
    </div>
</nav>
