<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pesanan - Fashion Store</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: '#66cdaa',
                        secondary: '#818CF8',
                        accent: '#C7D2FE',
                    }
                }
            }
        }
    </script>
</head>
<body class="bg-gray-50">
    <div class="max-w-[480px] mx-auto bg-white min-h-screen relative shadow-lg pb-20">
        <!-- Header -->
        <div class="fixed top-0 left-1/2 -translate-x-1/2 w-full max-w-[480px] bg-white z-50">
            <div class="flex items-center h-16 px-4 border-b border-gray-100">
                <h1 class="text-lg font-medium">Pesanan Saya</h1>
            </div>

            <!-- Order Status Tabs -->
            <div class="px-4 border-b border-gray-100 bg-white">
                <div class="flex overflow-x-auto hide-scrollbar gap-2 py-3">
                    <button class="px-4 py-2 rounded-full bg-primary text-white text-sm whitespace-nowrap">
                        Semua
                    </button>
                    <button class="px-4 py-2 rounded-full border border-gray-200 text-gray-600 text-sm whitespace-nowrap hover:border-primary hover:text-primary">
                        Belum Bayar
                    </button>
                    <button class="px-4 py-2 rounded-full border border-gray-200 text-gray-600 text-sm whitespace-nowrap hover:border-primary hover:text-primary">
                        Dikemas
                    </button>
                    <button class="px-4 py-2 rounded-full border border-gray-200 text-gray-600 text-sm whitespace-nowrap hover:border-primary hover:text-primary">
                        Dikirim
                    </button>
                    <button class="px-4 py-2 rounded-full border border-gray-200 text-gray-600 text-sm whitespace-nowrap hover:border-primary hover:text-primary">
                        Selesai
                    </button>
                </div>
            </div>
        </div>

        <!-- Main Content -->
        <div class="pt-32 px-4 space-y-4">
            <!-- Order Card 1 -->
            <div class="border border-gray-200 rounded-2xl overflow-hidden">
                <!-- Order Header -->
                <div class="p-4 border-b border-gray-100 bg-gray-50">
                    <div class="flex items-center justify-between mb-2">
                        <div class="flex items-center gap-2">
                            <i class="bi bi-shop text-primary"></i>
                            <span class="font-medium">Dewakoding Store</span>
                        </div>
                        <span class="text-primary font-medium">Dikemas</span>
                    </div>
                    <div class="text-xs text-gray-500">
                        23 Nov 2023 14:30
                    </div>
                </div>

                <!-- Order Items -->
                <div class="p-4">
                    <div class="flex gap-3">
                        <img src="https://i.ibb.co.com/JtLB93y/annoyed-young-pretty-girl-putting-fingers-ears-with-closed-eyes-min.jpg" 
                             alt="Kaos Polos Motif Putih"
                             class="w-20 h-20 object-cover rounded-lg">
                        <div>
                            <h3 class="text-sm font-medium">Kaos Polos Motif Putih</h3>
                            <p class="text-xs text-gray-500 mt-1">Putih, M</p>
                            <div class="mt-2">
                                <span class="text-sm text-gray-600">1 x </span>
                                <span class="text-sm font-medium">Rp125.000</span>
                            </div>
                        </div>
                    </div>
                    <div class="mt-3 pt-3 border-t border-gray-100">
                        <div class="flex justify-between items-center">
                            <span class="text-sm text-gray-600">Total Belanja</span>
                            <span class="text-primary font-semibold">Rp125.000</span>
                        </div>
                    </div>
                </div>

                <!-- Order Actions -->
                <div class="p-4 border-t border-gray-100 flex justify-end gap-3">
                    <button class="px-4 py-2 text-sm border border-gray-200 rounded-full text-gray-600 hover:border-primary hover:text-primary">
                        Lihat Detail
                    </button>
                    <button class="px-4 py-2 text-sm bg-primary text-white rounded-full hover:bg-primary/90">
                        Lacak Pesanan
                    </button>
                </div>
            </div>

            <!-- Order Card 2 -->
            <div class="border border-gray-200 rounded-2xl overflow-hidden">
                <!-- Order Header -->
                <div class="p-4 border-b border-gray-100 bg-gray-50">
                    <div class="flex items-center justify-between mb-2">
                        <div class="flex items-center gap-2">
                            <i class="bi bi-shop text-primary"></i>
                            <span class="font-medium">Dewakoding Store</span>
                        </div>
                        <span class="text-orange-500 font-medium">Belum Bayar</span>
                    </div>
                    <div class="text-xs text-gray-500">
                        23 Nov 2023 13:15
                    </div>
                </div>

                <!-- Order Items -->
                <div class="p-4">
                    <div class="flex gap-3">
                        <img src="https://i.ibb.co.com/L0hNqt6/man-wearing-t-shirt-gesturing-min.jpg" 
                             alt="Kaos Polos Abu Motif"
                             class="w-20 h-20 object-cover rounded-lg">
                        <div>
                            <h3 class="text-sm font-medium">Kaos Polos Abu Motif</h3>
                            <p class="text-xs text-gray-500 mt-1">Abu-abu, L</p>
                            <div class="mt-2">
                                <span class="text-sm text-gray-600">1 x </span>
                                <span class="text-sm font-medium">Rp115.000</span>
                            </div>
                        </div>
                    </div>
                    <div class="mt-3 pt-3 border-t border-gray-100">
                        <div class="flex justify-between items-center">
                            <span class="text-sm text-gray-600">Total Belanja</span>
                            <span class="text-primary font-semibold">Rp115.000</span>
                        </div>
                    </div>
                </div>

                <!-- Order Actions -->
                <div class="p-4 border-t border-gray-100 flex justify-end gap-3">
                    <button class="px-4 py-2 text-sm border border-gray-200 rounded-full text-gray-600 hover:border-primary hover:text-primary">
                        Batalkan
                    </button>
                    <button class="px-4 py-2 text-sm bg-primary text-white rounded-full hover:bg-primary/90">
                        Bayar Sekarang
                    </button>
                </div>
            </div>

            <!-- Order Card 3 -->
            <div class="border border-gray-200 rounded-2xl overflow-hidden">
                <!-- Order Header -->
                <div class="p-4 border-b border-gray-100 bg-gray-50">
                    <div class="flex items-center justify-between mb-2">
                        <div class="flex items-center gap-2">
                            <i class="bi bi-shop text-primary"></i>
                            <span class="font-medium">Dewakoding Store</span>
                        </div>
                        <span class="text-green-500 font-medium">Selesai</span>
                    </div>
                    <div class="text-xs text-gray-500">
                        22 Nov 2023 10:45
                    </div>
                </div>

                <!-- Order Items -->
                <div class="p-4">
                    <div class="flex gap-3">
                        <img src="https://i.ibb.co.com/fp3s0b6/pleased-young-pretty-girl-doing-ok-sign-min.jpg" 
                             alt="Kaos Hitam Motif"
                             class="w-20 h-20 object-cover rounded-lg">
                        <div>
                            <h3 class="text-sm font-medium">Kaos Hitam Motif Doff</h3>
                            <p class="text-xs text-gray-500 mt-1">Hitam, XL</p>
                            <div class="mt-2">
                                <span class="text-sm text-gray-600">1 x </span>
                                <span class="text-sm font-medium">Rp135.000</span>
                            </div>
                        </div>
                    </div>
                    <div class="mt-3 pt-3 border-t border-gray-100">
                        <div class="flex justify-between items-center">
                            <span class="text-sm text-gray-600">Total Belanja</span>
                            <span class="text-primary font-semibold">Rp135.000</span>
                        </div>
                    </div>
                </div>

                <!-- Order Actions -->
                <div class="p-4 border-t border-gray-100 flex justify-end gap-3">
                    <button class="px-4 py-2 text-sm border border-gray-200 rounded-full text-gray-600 hover:border-primary hover:text-primary">
                        Beli Lagi
                    </button>
                    <button class="px-4 py-2 text-sm bg-primary text-white rounded-full hover:bg-primary/90">
                        Nilai Produk
                    </button>
                </div>
            </div>
        </div>
    </div>

    <style>
        .hide-scrollbar {
            -ms-overflow-style: none;
            scrollbar-width: none;
        }
        .hide-scrollbar::-webkit-scrollbar {
            display: none;
        }
    </style>

    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
</body>
</html>