<div class="w-full max-w-[480px] md:max-w-none mx-auto md:mx-0 bg-gray-50 min-h-screen relative pb-[70px] md:pb-0">
        <!-- Header with Back Button - Mobile Only -->
        <div class="fixed md:hidden top-0 left-1/2 -translate-x-1/2 w-full max-w-[480px] bg-white z-50 shadow-sm">
            <div class="flex items-center justify-between h-16 px-4">
                <div class="flex items-center">
                        <button onclick="history.back()" class="p-2 hover:bg-gray-50 rounded-full">
                            <i class="bi bi-arrow-left text-xl"></i>
                        </button>
                        <h1 class="ml-2 text-lg font-semibold">Detail Produk</h1>
                </div>

                <a href="<?php echo e(route('shopping-cart')); ?>" class="relative p-2 hover:bg-gray-50 rounded-full transition-colors">
                    <i class="bi bi-cart text-xl"></i>
                    <!--[if BLOCK]><![endif]--><?php if($cartCount > 0): ?>
                    <div class="absolute -top-1 -right-1 bg-primary text-white text-xs w-5 h-5 flex items-center justify-center rounded-full font-semibold shadow-sm">
                        <?php echo e($cartCount); ?>

                    </div>
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                </a>
            </div>
        </div>

        <!-- Main Content -->
        <div class="pt-16 md:pt-8 md:px-8 lg:px-12 md:py-8">
            <!-- Desktop Breadcrumb & Title -->
            <div class="hidden md:block mb-6 max-w-7xl mx-auto">
                <div class="flex items-center gap-2 text-sm text-gray-500 mb-2">
                    <a href="<?php echo e(route('home')); ?>" class="hover:text-primary transition-colors">Home</a>
                    <i class="bi bi-chevron-right text-xs"></i>
                    <span class="text-gray-800 font-medium"><?php echo e($product->name); ?></span>
                </div>
            </div>

            <div class="md:grid md:grid-cols-[1fr_1fr] lg:grid-cols-[5fr_7fr] md:gap-8 md:max-w-7xl md:mx-auto">
                
                <!-- Left Column: Image -->
                <div class="md:sticky md:top-24 md:h-fit">
                    <!-- Product Images Slider -->
                    <div class="relative bg-gray-100 md:bg-white md:border md:border-gray-200 h-[350px] md:h-[480px] md:rounded-xl md:overflow-hidden flex items-center justify-center md:shadow-sm">
                        <!--[if BLOCK]><![endif]--><?php if($currentImage): ?>
                            <img src="<?php echo e(url('storage/'. $currentImage)); ?>" 
                                alt="<?php echo e($product->name); ?>" 
                                class="w-full h-full object-cover">
                        <?php else: ?>
                            <img src="<?php echo e(asset('image/no-pictures.png')); ?>" 
                                alt="No image available" 
                                class="w-1/3 h-auto object-contain opacity-60">
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if(count($images) > 1): ?>
                            <button wire:click="previousImage"
                                    class="absolute left-2 md:left-3 top-1/2 -translate-y-1/2 p-2 rounded-full bg-black/50 hover:bg-black/70 text-white transition-colors"
                                    <?php if($currentImageIndex == 0): ?> disabled <?php endif; ?>>
                                <i class="bi bi-chevron-left text-base"></i>
                            </button>

                            <button wire:click="nextImage"
                                class="absolute right-2 md:right-3 top-1/2 -translate-y-1/2 p-2 rounded-full bg-black/50 hover:bg-black/70 text-white transition-colors"
                                <?php if($currentImageIndex == count($images) - 1): ?> disabled <?php endif; ?>>
                                <i class="bi bi-chevron-right text-base"></i>
                            </button>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </div>
                    
                    <!-- Thumbnail Images -->
                    <!--[if BLOCK]><![endif]--><?php if(count($images) > 1): ?>
                    <div class="hidden md:flex gap-3 mt-4 overflow-x-auto pb-1">
                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <button 
                            wire:click="$set('currentImageIndex', <?php echo e($index); ?>)"
                            class="flex-shrink-0 w-20 h-20 rounded-lg border-2 overflow-hidden transition-all <?php echo e($currentImageIndex == $index ? 'border-primary ring-2 ring-primary/20' : 'border-gray-200 hover:border-gray-300'); ?>">
                            <img src="<?php echo e(url('storage/'. $image)); ?>" 
                                alt="<?php echo e($product->name); ?>" 
                                class="w-full h-full object-cover">
                        </button>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                    </div>
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                </div>
                
                <!-- Right Column: Product Details -->
                <div class="bg-white md:bg-transparent">
                    <!-- Product Info -->
                    <div class="p-4 md:p-6 md:bg-white md:rounded-xl md:border md:border-gray-200 md:shadow-sm md:mb-4">
                        <h2 class="text-xl md:text-2xl font-bold text-gray-800 mb-3"><?php echo e($product->name); ?></h2>
                        <div class="text-2xl md:text-3xl font-bold text-primary mb-4">Rp <?php echo e(number_format($displayPrice, 0, ',', '.')); ?></div>
                        
                        <!-- Display stock directly for products without variants -->
                        <!--[if BLOCK]><![endif]--><?php if(!$hasVariants): ?>
                        <div class="p-3 bg-gray-50 rounded-lg border border-gray-100">
                            <div class="flex justify-between items-center">
                                <span class="text-xs font-semibold text-gray-600">Stok:</span>
                                <span class="text-sm font-medium text-gray-800"><?php echo e($product->stock); ?></span>
                            </div>
                        </div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </div>

                    <!-- Variant Selector -->
                    <!--[if BLOCK]><![endif]--><?php if($hasVariants && count($variantTypes) > 0): ?>
                    <div class="p-4 md:p-6 md:bg-white md:rounded-xl md:border md:border-gray-200 md:shadow-sm md:mb-4">
                        <h3 class="text-base md:text-lg font-bold mb-4 text-gray-800">Pilih Varian</h3>
                        
                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $variantTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $typeName => $options): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="mb-3 last:mb-0">
                            <h4 class="text-xs font-semibold text-gray-600 mb-2"><?php echo e($typeName); ?></h4>
                            <div class="flex flex-wrap gap-2">
                                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <button
                                    wire:click="selectOption('<?php echo e($typeName); ?>', '<?php echo e($option); ?>')"
                                    class="px-3 py-2 border-2 rounded-lg text-sm font-medium transition-all <?php echo e(isset($selectedOptions[$typeName]) && $selectedOptions[$typeName] === $option ? 'border-primary bg-primary text-white' : 'border-gray-200 text-gray-700 hover:border-primary hover:text-primary'); ?>">
                                    <?php echo e($option); ?>

                                </button>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                        
                        <!-- Show selected variant stock -->
                        <!--[if BLOCK]><![endif]--><?php if($selectedVariant): ?>
                        <div class="mt-3 p-3 bg-gray-50 rounded-lg border border-gray-100">
                            <div class="flex justify-between items-center">
                                <span class="text-xs font-semibold text-gray-600">Stok:</span>
                                <span class="text-sm font-medium text-gray-800"><?php echo e($selectedVariant->stock); ?></span>
                            </div>
                        </div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </div>
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                    <!-- Desktop Action Button -->
                    <div class="hidden md:block md:p-6 md:bg-white md:rounded-xl md:border md:border-gray-200 md:shadow-sm">
                        <div class="space-y-4">
                            <button 
                                wire:click="addToCart(<?php echo e($product->id); ?>)"
                                <?php echo e(($hasVariants && !$selectedVariantId) ? 'disabled' : ''); ?>

                                class="w-full h-12 flex items-center justify-center gap-2 rounded-xl bg-primary text-white font-semibold hover:bg-primary/90 transition-all disabled:opacity-50 disabled:cursor-not-allowed shadow-lg shadow-primary/20">
                                <i class="bi bi-cart-plus text-lg"></i>
                                Tambah ke Keranjang
                            </button>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Product Description - Desktop Full Width -->
            <div class="hidden md:block md:mt-6 md:max-w-7xl md:mx-auto">
                <div class="p-6 bg-white rounded-xl border border-gray-200 shadow-sm">
                    <h3 class="text-lg font-bold mb-4 text-gray-800">Deskripsi Produk</h3>
                    <div class="text-gray-600 text-sm md:text-base leading-relaxed">
                        <?php echo $product->description; ?>

                    </div>
                </div>
            </div>
        </div>

        <!-- Bottom Navigation for Add to Cart & Buy -->
        <div class="fixed bottom-[70px] left-1/2 -translate-x-1/2 w-full max-w-[480px] bg-white border-t border-gray-200 p-4 z-50 md:hidden shadow-lg">
            <button 
                wire:click="addToCart(<?php echo e($product->id); ?>)" 
                class="w-full h-12 flex items-center justify-center gap-2 rounded-xl bg-primary text-white font-bold hover:bg-primary/90 transition-colors shadow-lg shadow-primary/30
                    <?php echo e(($hasVariants && !$selectedVariantId) ? 'opacity-75 cursor-not-allowed' : ''); ?>">
                <i class="bi bi-cart-plus text-lg"></i>
                Tambah ke Keranjang
            </button>
        </div>
    </div><?php /**PATH C:\wamp64\www\olshop\resources\views/livewire/product-detail.blade.php ENDPATH**/ ?>