<div class="w-full max-w-[480px] md:max-w-none mx-auto md:mx-0 bg-gray-50 min-h-screen relative pb-24 md:pb-0">
    <!-- Header Mobile Only -->
    <div class="fixed md:hidden top-0 left-1/2 -translate-x-1/2 w-full max-w-[480px] bg-white z-50 shadow-sm">
        <div class="flex items-center h-16 px-4">
            <button onclick="history.back()" class="p-2 rounded-full hover:bg-gray-50">
                <i class="text-xl bi bi-arrow-left"></i>
            </button>
            <h1 class="ml-2 text-lg font-semibold">Detail Pesanan</h1>
        </div>
    </div>

    <!-- Main Content -->
    <div class="px-4 pt-16 md:pt-8 md:px-8 lg:px-12 md:py-8">
        <!-- Desktop Title & Breadcrumb -->
        <div class="hidden mb-6 md:block">
            <div class="flex items-center gap-2 mb-2 text-sm text-gray-500">
                <a href="<?php echo e(route('orders')); ?>" class="transition-colors hover:text-primary">Pesanan</a>
                <i class="text-xs bi bi-chevron-right"></i>
                <span class="font-medium text-gray-800">Detail Pesanan</span>
            </div>
            <div class="flex items-center justify-between">
                <div>
                    <h1 class="text-2xl font-bold text-gray-800">Detail Pesanan</h1>
                    <p class="mt-1 text-sm text-gray-500">Order #<?php echo e($order->order_number); ?></p>
                </div>
                <div class="text-right">
                    <div class="mb-1 text-sm text-gray-500"><?php echo e($order->created_at->format('d M Y, H:i')); ?></div>
                    <span data-payment-status="<?php echo e($order->payment_status); ?>" class="inline-flex items-center px-3 py-1.5 rounded-full text-sm font-medium
                        <?php if($order->payment_status === 'paid'): ?> bg-green-100 text-green-800
                        <?php else: ?> bg-orange-100 text-orange-800
                        <?php endif; ?>">
                        <!--[if BLOCK]><![endif]--><?php if($order->payment_status === 'paid'): ?>
                            <i class="mr-1.5 bi bi-check-circle-fill"></i> Sudah Dibayar
                        <?php else: ?>
                            <i class="mr-1.5 bi bi-clock-fill"></i> Belum Dibayar
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </span>
                </div>
            </div>
        </div>

        <!-- Order Status -->
        <!-- Flash Messages -->
        <!--[if BLOCK]><![endif]--><?php if(session()->has('message')): ?>
            <div class="p-4 mb-4 text-green-700 border border-green-200 rounded-lg bg-green-50">
                <?php echo e(session('message')); ?>

            </div>
        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

        <?php if(session()->has('error')): ?>
            <div class="p-4 mb-4 text-red-700 border border-red-200 rounded-lg bg-red-50">
                <?php echo e(session('error')); ?>

            </div>
        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

        <div class="bg-<?php echo e($statusInfo['color']); ?>-50 p-4 md:p-5 rounded-xl mb-6 border border-<?php echo e($statusInfo['color']); ?>-200">
            <div class="flex items-center gap-3">
                <i class="bi <?php echo e($statusInfo['icon']); ?> text-2xl md:text-3xl text-<?php echo e($statusInfo['color']); ?>-500"></i>
                <div>
                    <h2 class="font-medium md:text-lg text-<?php echo e($statusInfo['color']); ?>-600"><?php echo e($statusInfo['title']); ?></h2>
                    <p class="text-sm text-<?php echo e($statusInfo['color']); ?>-600"><?php echo e($statusInfo['message']); ?></p>
                </div>
            </div>
        </div>

        <!-- 2 Column Layout for Desktop -->
        <div class="md:grid md:grid-cols-[1fr_380px] md:gap-6 md:items-start">
            <!-- Left Column: Order Details -->
            <div class="space-y-6">
                <!--[if BLOCK]><![endif]--><?php if($this->hasOnlyDigitalProducts()): ?>
                    <!-- Digital Product Notice -->
                    <div class="overflow-hidden border border-blue-200 shadow-sm bg-gradient-to-r from-blue-50 to-indigo-50 rounded-xl">
                        <div class="p-4">
                            <div class="flex items-start gap-3">
                                <div class="flex items-center justify-center flex-shrink-0 w-10 h-10 bg-blue-100 rounded-full">
                                    <i class="text-lg text-blue-600 bi bi-download"></i>
                                </div>
                                <div>
                                    <h3 class="mb-1 font-semibold text-gray-800">Produk Digital</h3>
                                    <p class="text-sm text-gray-600">
                                        Pesanan Anda berisi produk digital. Tidak ada pengiriman fisik.
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                <!-- Order Details -->
                <div class="overflow-hidden bg-white border border-gray-200 shadow-sm rounded-xl">
            <div class="p-4 border-b border-gray-200 md:p-5 bg-gray-50">
                <div class="flex items-center justify-between mb-2">
                    <h3 class="font-medium md:text-lg">Detail Pesanan</h3>
                    <span class="font-mono text-sm text-gray-500"><?php echo e($order->order_number); ?></span>
                </div>
                <div class="flex items-center justify-between">
                    <div class="text-sm text-gray-500"> <?php echo e($order->created_at->format('d M Y H:i')); ?></div>
                    <span data-payment-status="<?php echo e($order->payment_status); ?>" class="inline-flex items-center px-2.5 py-1 rounded-full text-xs font-medium
                        <?php if($order->payment_status === 'paid'): ?> bg-green-100 text-green-800 border border-green-200
                        <?php else: ?> bg-orange-100 text-orange-800 border border-orange-200
                        <?php endif; ?>">
                        <!--[if BLOCK]><![endif]--><?php if($order->payment_status === 'paid'): ?>
                            <i class="mr-1 bi bi-check-circle-fill"></i>
                            Sudah Dibayar
                        <?php else: ?>
                            <i class="mr-1 bi bi-clock-fill"></i>
                            Belum Dibayar
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </span>
                </div>
            </div>

            <div class="p-4 md:p-5">
                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $order->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="flex gap-3 pb-4 mb-4 <?php echo e(!$loop->last ? 'border-b border-gray-100' : ''); ?>">
                        <img src="<?php echo e($item->product->first_image_url ?? asset('image/no-pictures.png')); ?>" alt="Product"
                            class="object-cover w-20 h-20 rounded-lg">
                        <div>
                            <h4 class="font-medium"><?php echo e($item->product_name); ?></h4>

                            <!--[if BLOCK]><![endif]--><?php if($item->product && $item->product->is_product_digital): ?>
                                <span class="inline-block mt-1 text-xs px-2 py-0.5 bg-blue-100 text-blue-700 rounded-full">
                                    Digital
                                </span>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                            <!-- Tampilkan informasi varian jika tersedia -->
                            <!--[if BLOCK]><![endif]--><?php if($item->product_variant_id): ?>
                                <div class="mt-1">
                                    <!--[if BLOCK]><![endif]--><?php if(isset($item->variant_type1) && isset($item->variant_option1)): ?>
                                        <p class="text-xs text-gray-500">
                                            <span class="font-medium"><?php echo e($item->variant_type1); ?>:</span>
                                            <?php echo e($item->variant_option1); ?>

                                        </p>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                                    <!--[if BLOCK]><![endif]--><?php if(isset($item->variant_type2) && isset($item->variant_option2)): ?>
                                        <p class="text-xs text-gray-500">
                                            <span class="font-medium"><?php echo e($item->variant_type2); ?>:</span>
                                            <?php echo e($item->variant_option2); ?>

                                        </p>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                                    <!--[if BLOCK]><![endif]--><?php if(!isset($item->variant_type1) && isset($item->variant_name)): ?>
                                        <p class="text-xs text-gray-500"><?php echo e($item->variant_name); ?></p>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                            <div class="mt-1">
                                <span class="text-sm"><?php echo e($item->quantity); ?> x </span>
                                <span class="font-medium">Rp <?php echo e(number_format($item->price, 0, ',', '.')); ?></span>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->

                <div class="pt-4 space-y-2">
                    <div class="flex justify-between text-sm">
                        <span class="text-gray-600">Subtotal</span>
                        <span>Rp <?php echo e(number_format($order->subtotal, 0, ',', '.')); ?></span>
                    </div>
                    <!--[if BLOCK]><![endif]--><?php if(!$this->hasOnlyDigitalProducts()): ?>
                    <div class="flex justify-between text-sm">
                        <span class="text-gray-600">Ongkir</span>
                        <span>Rp <?php echo e(number_format($order->shipping_cost, 0, ',', '.')); ?></span>
                    </div>
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    <div class="pt-2 border-t border-gray-200">
                        <div class="flex justify-between font-medium">
                            <span>Total</span>
                            <span class="text-primary">Rp <?php echo e(number_format($order->total_amount, 0, ',', '.')); ?></span>
                        </div>
                    </div>
                </div>
            </div>
                </div>
            </div>
            <!-- End Left Column -->

            <!-- Right Column: Shipping & Payment Info -->
            <div class="mt-6 space-y-6 md:mt-0">
                <!-- Contact/Shipping Details -->
                <div class="mb-6 overflow-hidden bg-white border border-gray-200 shadow-sm rounded-xl">
                    <div class="p-4 border-b border-gray-200 md:p-5 bg-gray-50">
                        <h3 class="font-medium md:text-lg">
                            <!--[if BLOCK]><![endif]--><?php if($this->hasOnlyDigitalProducts()): ?>
                                Informasi Pemesan
                            <?php else: ?>
                                Informasi Pengiriman
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        </h3>
                    </div>
                    <div class="p-4 space-y-3 md:p-5">
                        <div class="flex gap-2">
                            <span class="text-gray-600 min-w-[140px]">Nama <?php echo e($this->hasOnlyDigitalProducts() ? 'Pemesan' : 'Penerima'); ?></span>
                            <span>: <?php echo e($order->recipient_name); ?></span>
                        </div>
                        <div class="flex gap-2">
                            <span class="text-gray-600 min-w-[140px]">No. Telepon</span>
                            <span>: <?php echo e($order->phone); ?></span>
                        </div>

                        <!--[if BLOCK]><![endif]--><?php if(!$this->hasOnlyDigitalProducts()): ?>
                        <div class="flex gap-2">
                            <span class="text-gray-600 min-w-[140px]">Alamat</span>
                            <span>: <?php echo e($order->shipping_address); ?>, <?php echo e($order->shipping_area_name); ?></span>
                        </div>
                <?php
                    $shippingDetail = $order->shipping_method_detail;
                    // Handle old data that might still be JSON string
                    if (is_string($shippingDetail)) {
                        $shippingDetail = json_decode($shippingDetail, true);
                    }
                ?>
                <!--[if BLOCK]><![endif]--><?php if($shippingDetail && is_array($shippingDetail)): ?>
                    <!-- Courier Info Card -->
                    <div class="p-3 mb-3 border border-gray-200 rounded-lg bg-gray-50">
                        <div class="flex items-center space-x-3">
                            <div class="flex items-center justify-center w-8 h-8 bg-blue-100 rounded-full">
                                <i class="text-blue-600 bi bi-truck"></i>
                            </div>
                            <div class="flex-1">
                                <p class="text-sm font-medium text-gray-900">
                                    <?php echo e($shippingDetail['courier_name'] ?? 'N/A'); ?> -
                                    <?php echo e($shippingDetail['courier_service_name'] ?? $shippingDetail['service'] ?? 'N/A'); ?>

                                </p>
                                <p class="text-xs text-gray-500">Estimasi: <?php echo e($shippingDetail['duration'] ?? 'N/A'); ?></p>
                            </div>
                        </div>
                    </div>
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                <!--[if BLOCK]><![endif]--><?php if($order->shipping_tracking_number): ?>
                    <!-- No Resi - Compact Version -->
                    <div class="p-3 mb-3 border border-gray-200 rounded-lg bg-gray-50">
                        <div class="flex items-center justify-between">
                            <div>
                                <p class="mb-1 text-xs text-gray-500">No. Resi</p>
                                <p class="text-sm font-semibold text-gray-900"><?php echo e($order->shipping_tracking_number); ?></p>
                            </div>
                            <button
                                onclick="copyToClipboard('<?php echo e($order->shipping_tracking_number); ?>', this)"
                                class="flex items-center px-2 py-1.5 bg-white rounded border border-gray-200 text-gray-600 hover:text-blue-600 hover:border-blue-300 transition-colors">
                                <i class="text-sm bi bi-clipboard"></i>
                            </button>
                        </div>
                    </div>
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                <!--[if BLOCK]><![endif]--><?php if($order->shipping_tracking_number): ?>
                    <!-- Shipping History Timeline Section -->
                    <div class="mt-4">
                        <!-- Header - Always visible -->
                        <div class="flex items-center justify-between mb-4">
                            <h4 class="flex items-center text-sm font-semibold text-gray-900">
                                <i class="mr-2 text-blue-600 bi bi-clock-history"></i>
                                Riwayat Pengiriman
                            </h4>
                            <div class="flex items-center gap-2">
                                <?php
                                    $shippingDetailForCode = $order->shipping_method_detail;
                                    if (is_string($shippingDetailForCode)) {
                                        $shippingDetailForCode = json_decode($shippingDetailForCode, true);
                                    }

                                    // Extract Biteship tracking URL from shipping_order_data
                                    $biteshipTrackingUrl = null;
                                    if ($order->shipping_order_data) {
                                        $shippingOrderData = $order->shipping_order_data;
                                        if (is_string($shippingOrderData)) {
                                            $shippingOrderData = json_decode($shippingOrderData, true);
                                        }
                                        if (is_array($shippingOrderData) && isset($shippingOrderData['courier']['link'])) {
                                            $biteshipTrackingUrl = $shippingOrderData['courier']['link'];
                                        }
                                    }
                                ?>
                                <!--[if BLOCK]><![endif]--><?php if($biteshipTrackingUrl): ?>
                                <a
                                    href="<?php echo e($biteshipTrackingUrl); ?>"
                                    target="_blank"
                                    class="flex items-center text-xs text-blue-600 hover:text-blue-700">
                                    Detail
                                    <i class="ml-1 text-xs bi bi-box-arrow-up-right"></i>
                                </a>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                <button wire:click="refreshTracking" wire:loading.attr="disabled"
                                    class="flex items-center px-2 py-1 text-xs font-medium text-blue-600 transition-colors rounded bg-blue-50 hover:bg-blue-100 disabled:opacity-50">
                                    <i class="text-xs bi bi-arrow-clockwise" wire:loading.class="animate-spin"
                                        wire:target="refreshTracking"></i>
                                </button>
                            </div>
                        </div>

                        <!-- Timeline Content - Lazy Loaded -->
                        <div wire:init="loadTrackingInfo">
                            <!--[if BLOCK]><![endif]--><?php if($isLoadingTracking): ?>
                                <!-- Loading State with Circular Progress -->
                                <div class="flex items-center justify-center py-12">
                                    <div class="text-center">
                                        <!-- Circular Loading Animation -->
                                        <div class="relative inline-flex items-center justify-center w-16 h-16 mb-4">
                                            <!-- Outer rotating circle -->
                                            <div class="absolute w-16 h-16 border-4 border-blue-100 rounded-full"></div>
                                            <!-- Animated arc -->
                                            <div class="absolute w-16 h-16 border-4 border-transparent rounded-full border-t-blue-500 animate-spin"></div>
                                            <!-- Inner icon -->
                                            <i class="text-xl text-blue-500 bi bi-truck"></i>
                                        </div>
                                        <p class="text-sm font-medium text-gray-700">Memuat riwayat pengiriman...</p>
                                        <p class="mt-1 text-xs text-gray-500">Mohon tunggu sebentar</p>
                                    </div>
                                </div>
                            <?php else: ?>
                                <?php
                                    $shippingHistory = $this->getShippingHistory();
                                ?>
                                <!--[if BLOCK]><![endif]--><?php if(!empty($shippingHistory)): ?>
                                    <!-- Current Status Badge -->
                                    <!--[if BLOCK]><![endif]--><?php if($trackingInfo && isset($trackingInfo['status'])): ?>
                                    <div class="mb-4">
                                        <span class="inline-flex items-center px-3 py-1.5 rounded-full text-xs font-medium
                                            <?php if($trackingInfo['status'] == 'delivered'): ?> bg-green-100 text-green-800 border border-green-200
                                            <?php elseif(in_array($trackingInfo['status'], ['confirmed', 'allocated', 'picking_up'])): ?> bg-yellow-100 text-yellow-800 border border-yellow-200
                                            <?php elseif(in_array($trackingInfo['status'], ['picked', 'dropping_off'])): ?> bg-blue-100 text-blue-800 border border-blue-200
                                            <?php elseif(in_array($trackingInfo['status'], ['cancelled', 'returned'])): ?> bg-red-100 text-red-800 border border-red-200
                                            <?php else: ?> bg-gray-100 text-gray-800 border border-gray-200
                                            <?php endif; ?>">
                                            <!--[if BLOCK]><![endif]--><?php if($trackingInfo['status'] == 'delivered'): ?>
                                                <i class="mr-1.5 text-green-600 bi bi-check-circle-fill"></i>
                                            <?php elseif(in_array($trackingInfo['status'], ['picked', 'dropping_off'])): ?>
                                                <i class="mr-1.5 text-blue-600 bi bi-truck"></i>
                                            <?php elseif(in_array($trackingInfo['status'], ['confirmed', 'allocated', 'picking_up'])): ?>
                                                <i class="mr-1.5 text-yellow-600 bi bi-clock-fill"></i>
                                            <?php elseif(in_array($trackingInfo['status'], ['cancelled', 'returned'])): ?>
                                                <i class="mr-1.5 text-red-600 bi bi-x-circle-fill"></i>
                                            <?php else: ?>
                                                <i class="mr-1.5 text-gray-600 bi bi-circle-fill"></i>
                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                            <?php echo e(ucfirst(str_replace('_', ' ', $trackingInfo['status']))); ?>

                                        </span>
                                    </div>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                                <div class="relative">
                                    <!-- Timeline Line -->
                                    <div class="absolute left-4 top-0 bottom-0 w-0.5 bg-gray-200"></div>

                                    <!-- Timeline Items -->
                                    <div class="space-y-4">
                                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = collect($shippingHistory)->sortByDesc('updated_at')->values(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $history): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php
                                                $isLatest = $index === 0;
                                            ?>
                                            <div class="relative pb-4 pl-10">
                                                <!-- Timeline Dot -->
                                                <div
                                                    class="absolute left-0 w-8 h-8 bg-<?php echo e($isLatest ? 'blue' : 'gray'); ?>-100 border-2 border-<?php echo e($isLatest ? 'blue' : 'gray'); ?>-400 rounded-full flex items-center justify-center">
                                                    <!--[if BLOCK]><![endif]--><?php if($isLatest): ?>
                                                        <i class="text-xs text-blue-600 bi bi-geo-alt-fill"></i>
                                                    <?php else: ?>
                                                        <div class="w-2 h-2 bg-gray-400 rounded-full"></div>
                                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                                </div>

                                                <!-- Content -->
                                                <div
                                                    class="bg-<?php echo e($isLatest ? 'blue-50 border-blue-200' : 'gray-50 border-gray-200'); ?> border rounded-lg p-3">
                                                    <p class="font-medium text-<?php echo e($isLatest ? 'blue' : 'gray'); ?>-900 text-sm">
                                                        <?php echo e($history['note'] ?? $history['status'] ?? 'Status Update'); ?>

                                                    </p>
                                                    <!--[if BLOCK]><![endif]--><?php if(isset($history['updated_at'])): ?>
                                                        <p class="text-xs text-<?php echo e($isLatest ? 'blue' : 'gray'); ?>-600 mt-1">
                                                            <i class="mr-1 bi bi-clock"></i>
                                                            <?php echo e(\Carbon\Carbon::parse($history['updated_at'])->timezone('Asia/Jakarta')->format('d M Y, H:i')); ?>

                                                            WIB
                                                        </p>
                                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                    </div>
                                </div>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        </div>
                    </div>
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
            </div>
        </div>
        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

        <!--[if BLOCK]><![endif]--><?php if($order->payment_status === 'unpaid' && ($order->payment_gateway_transaction_id == null)): ?>
    <!-- Payment Instructions -->
    <div class="space-y-4">
        <h3 class="font-medium">Petunjuk Pembayaran</h3>

        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $paymentMethods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <!-- BCA -->
            <div class="overflow-hidden border rounded-xl">
                <div class="flex items-center gap-3 p-4 border-b bg-gray-50">
                    <img src="<?php echo e(Storage::url($item->image)); ?>" alt="BCA" class="h-6">
                    <span class="font-medium"><?php echo e($item->name); ?></span>
                </div>
                <div class="p-4">
                    <div class="flex items-center justify-between">
                        <div class="space-y-1">
                            <div class="text-sm text-gray-500">Nomor Rekening:</div>
                            <div class="font-mono text-lg font-medium"><?php echo e($item->account_number); ?></div>
                            <div class="text-sm text-gray-500">a.n. <?php echo e($item->account_name); ?></div>
                        </div>
                        <button class="text-primary hover:text-primary/80"
                            onclick="copyToClipboard('<?php echo e($item->account_number); ?>', this)">
                            <i class="text-xl bi bi-clipboard"></i>
                        </button>
                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
    </div>
    <!-- Important Notes -->
    <div class="p-4 mt-6 bg-blue-50 rounded-xl">
        <div class="flex items-start gap-3">
            <i class="bi bi-info-circle-fill text-blue-500 mt-0.5"></i>
            <div class="text-sm text-blue-700">
                <p class="mb-1 font-medium">Penting:</p>
                <ul class="space-y-1 list-disc list-inside">
                    <li>Transfer sesuai dengan nominal yang tertera</li>
                    <li>Simpan bukti pembayaran</li>
                    <li>Upload bukti pembayaran setelah transfer</li>
                </ul>
            </div>
        </div>
    </div>
<?php endif; ?><!--[if ENDBLOCK]><![endif]-->

<!--[if BLOCK]><![endif]--><?php if($order->payment_proof): ?>
    <div class="p-4 mt-6 mb-6 border border-gray-200 rounded-xl">
        <h3 class="mb-4 font-medium">Bukti Pembayaran</h3>
        <div class="space-y-3">
            <img src="<?php echo e(Storage::url($order->payment_proof)); ?>" alt="Bukti Pembayaran"
                class="w-full border border-gray-100 rounded-lg" />

        </div>
    </div>
<?php endif; ?><!--[if ENDBLOCK]><![endif]-->

<?php if($order->payment_status === 'unpaid' && ($order->payment_gateway_transaction_id == null) && ($order->payment_proof == null)): ?>
    <!-- Desktop Payment Button -->
    <div class="hidden md:block">
        <a href="<?php echo e(route('payment-confirmation', ['orderNumber' => $order->order_number])); ?>"
            class="block w-full py-3 font-medium text-center text-white transition-colors bg-primary rounded-xl hover:bg-primary/90">
            Konfirmasi Pembayaran
        </a>
    </div>
<?php endif; ?><!--[if ENDBLOCK]><![endif]-->
            </div>
            <!-- End Right Column -->



<?php if($order->payment_status === 'unpaid' && ($order->payment_gateway_transaction_id == null) && ($order->payment_proof == null)): ?>
    <!-- Bottom Button - Mobile Only -->
    <div class="md:hidden fixed bottom-0 left-1/2 -translate-x-1/2 w-full max-w-[480px] bg-white border-t border-gray-100 p-4 z-50">
        <a href="<?php echo e(route('payment-confirmation', ['orderNumber' => $order->order_number])); ?>"
            class="block w-full py-3 font-medium text-center text-white transition-colors bg-primary rounded-xl hover:bg-primary/90">
            Konfirmasi Pembayaran
        </a>
    </div>
<?php endif; ?><!--[if ENDBLOCK]><![endif]-->
        </div>
        <!-- End Grid Container -->
<?php $__env->startPush('scripts'); ?>
    <script type="text/javascript" src="https://app.sandbox.midtrans.com/snap/snap.js"
        data-client-key="<?php echo e(config('services.midtrans.client_key')); ?>">
        </script>

    <script>
        document.addEventListener('livewire:initialized', () => {
            const snapToken = "<?php echo e($order->payment_gateway_transaction_id); ?>";
            const orderId = "<?php echo e($order->order_number); ?>";
            const orderPaymentStatus = "<?php echo e($order->payment_status); ?>";
            const orderShippingStatus = "<?php echo e($order->shipping_status); ?>";

            // Tampilkan popup Midtrans hanya jika status masih pending
            if (snapToken && orderStatus === 'pending') {
                try {
                    window.snap.pay(snapToken, {
                        onSuccess: function (result) {
                            window.location.reload();
                        },
                        onPending: function (result) {
                            window.location.reload();
                        },
                        onError: function (result) {
                            alert('Pembayaran gagal! Silakan coba lagi.');
                        },
                        onClose: function () {
                            // Jika user menutup popup, tetap di halaman detail order
                            window.location.reload();
                        }
                    });
                } catch (error) {
                    console.error('Terjadi kesalahan saat membuka popup pembayaran:', error);
                }
            }
        });

        // Copy to clipboard function with better UX
        function copyToClipboard(text, buttonElement) {
            navigator.clipboard.writeText(text).then(function () {
                // Find the copy button and show feedback
                const copyBtn = buttonElement;
                const originalContent = copyBtn.innerHTML;

                // Change button content temporarily
                copyBtn.innerHTML = '<i class="text-lg bi bi-check"></i><span class="text-sm font-medium">Tersalin!</span>';
                copyBtn.classList.remove('text-gray-600', 'hover:text-blue-600');
                copyBtn.classList.add('text-green-600', 'border-green-300');

                // Reset after 2 seconds
                setTimeout(() => {
                    copyBtn.innerHTML = originalContent;
                    copyBtn.classList.remove('text-green-600', 'border-green-300');
                    copyBtn.classList.add('text-gray-600', 'hover:text-blue-600');
                }, 2000);
            }).catch(function (error) {
                console.log('Gagal menyalin ke clipboard', error);
                alert('Gagal menyalin ke clipboard');
            });
        }
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH C:\wamp64\www\olshop\resources\views/livewire/order-detail.blade.php ENDPATH**/ ?>