<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo e($store->name ?? 'Toko Online'); ?></title>

    <!-- Favicon & App Icons -->
    <link rel="icon" type="image/png" href="<?php echo e($store->imageUrl ?? asset('image/store.png')); ?>">
    <link rel="apple-touch-icon" href="<?php echo e($store->imageUrl ?? asset('image/store.png')); ?>">
    <meta name="msapplication-TileImage" content="<?php echo e($store->imageUrl ?? asset('image/store.png')); ?>">
    <meta name="theme-color" content="<?php echo e($store->primary_color ?? '#ff6666'); ?>">

    <?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::styles(); ?>


    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: "<?php echo e($store->primary_color ?? '#ff6666'); ?>",
                        secondary: "<?php echo e($store->secondary_color ?? '#818CF8'); ?>",
                        accent: '#C7D2FE',
                    }
                }
            }
        }
    </script>
</head>

<body class="bg-gray-50 md:pt-[70px]">

    <?php if(!isset($hideBottomNav) || !$hideBottomNav): ?>
        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('components.bottom-navigation');

$__html = app('livewire')->mount($__name, $__params, 'lw-3404561302-0', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
    <?php elseif(isset($hideBottomNavMobile) && $hideBottomNavMobile): ?>
        <div class="md:hidden">
            <!-- Hidden on mobile only -->
        </div>
        <div class="hidden md:block">
            <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('components.bottom-navigation');

$__html = app('livewire')->mount($__name, $__params, 'lw-3404561302-1', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
        </div>
    <?php endif; ?>

    <?php echo e($slot); ?>


    <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('components.alert');

$__html = app('livewire')->mount($__name, $__params, 'lw-3404561302-2', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>

    <!-- FAB Beli Template - Collapsible -->
    <div class="fixed z-50 bottom-24 md:bottom-8 left-1/2 md:left-auto -translate-x-1/2 md:translate-x-0 md:right-8 w-full max-w-[480px] md:max-w-none md:w-auto pointer-events-none">
        <div x-data="{ expanded: false }" class="absolute bottom-0 pointer-events-auto right-4 md:right-0 md:relative">
            <!-- Expanded State -->
            <!--div x-show="expanded" x-cloak x-transition:enter="transition ease-out duration-200"
                x-transition:enter-start="opacity-0 translate-x-8" x-transition:enter-end="opacity-100 translate-x-0"
                x-transition:leave="transition ease-in duration-150"
                x-transition:leave-start="opacity-100 translate-x-0" x-transition:leave-end="opacity-0 translate-x-8"
                class="relative">
                <a href="https://dewakoding.com/tutorial/source-code-toko-online-lengkap-payment-ekspedisi-otomatis"
                    target="_blank"
                    class="flex items-center gap-2 px-4 py-3 text-sm font-medium text-white transition-all duration-200 bg-blue-600 rounded-full shadow-lg hover:bg-blue-700 hover:shadow-xl">
                    <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" fill="none" viewBox="0 0 24 24"
                        stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M3 3h2l.4 2M7 13h10l4-8H5.4M7 13L5.4 5M7 13l-2.293 2.293c-.63.63-.184 1.707.707 1.707H17m0 0a2 2 0 100 4 2 2 0 000-4zm-8 2a2 2 0 11-4 0 2 2 0 014 0z" />
                    </svg>
                    Beli Source Code 1
                </a>
                <button @click="expanded = false"
                    class="absolute flex items-center justify-center w-6 h-6 text-white transition-all duration-200 bg-red-500 rounded-full shadow-md -top-2 -right-2 hover:bg-red-600">
                    <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4" fill="none" viewBox="0 0 24 24"
                        stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M6 18L18 6M6 6l12 12" />
                    </svg>
                </button>
            </div> <!-- Collapsed State - Circle Button with Animation -->
            <button x-show="!expanded" x-cloak @click="expanded = true"
                x-transition:enter="transition ease-out duration-200" x-transition:enter-start="opacity-0 scale-75"
                x-transition:enter-end="opacity-100 scale-100" x-transition:leave="transition ease-in duration-150"
                x-transition:leave-start="opacity-100 scale-100" x-transition:leave-end="opacity-0 scale-75"
                class="relative flex items-center justify-center text-white bg-blue-600 rounded-full shadow-lg w-14 h-14 hover:bg-blue-700 hover:shadow-xl fab-bounce">
                <!-- Pulse Ring Animation -->
                <span class="absolute w-full h-full bg-blue-400 rounded-full opacity-75 animate-ping"></span>
                <!-- Icon -->
                <svg xmlns="http://www.w3.org/2000/svg" class="relative w-6 h-6" fill="none" viewBox="0 0 24 24"
                    stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                        d="M3 3h2l.4 2M7 13h10l4-8H5.4M7 13L5.4 5M7 13l-2.293 2.293c-.63.63-.184 1.707.707 1.707H17m0 0a2 2 0 100 4 2 2 0 000-4zm-8 2a2 2 0 11-4 0 2 2 0 014 0z" />
                </svg>
            </button>
        </div>
    </div>

    <style>
        [x-cloak] {
            display: none !important;
        }

        @keyframes fab-bounce {

            0%,
            100% {
                transform: translateY(0);
            }

            50% {
                transform: translateY(-6px);
            }
        }

        .fab-bounce {
            animation: fab-bounce 1.5s ease-in-out infinite;
        }
    </style>

    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">

    <?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::scripts(); ?>


    <?php echo $__env->yieldPushContent('scripts'); ?>
    <!--Start of Tawk.to Script - FIXED dengan DELAY & CSP-->
<meta http-equiv="Content-Security-Policy" content="script-src 'self' 'unsafe-inline' https://embed.tawk.to https://*.tawk.to https://tawk.to; frame-src https://*.tawk.to https://embed.tawk.to; connect-src https://*.tawk.to;"> <!-- Tambah di <head> jika belum ada -->

<script type="text/javascript">
setTimeout(function() {
    var Tawk_API=Tawk_API||{}, Tawk_LoadStart=new Date();
    (function(){
    var s1=document.createElement("script"),s0=document.getElementsByTagName("script")[0];
    s1.async=true;
    s1.src='https://embed.tawk.to/65962d830ff6374032bbfba7/60482fd083f84849959acb6ecc1736ae33d95d1b';
    s1.charset='UTF-8';
    s1.setAttribute('crossorigin','*');
    s0.parentNode.insertBefore(s1,s0);
    })();
}, 3000); <!-- Delay 3 detik hindari Livewire/Alpine conflict -->
</script>
<!--End of Tawk.to Script-->
<style>
.tawk_floating_button {
    z-index: 9999 !important;
    bottom: 120px !important; /* Atas FAB */
}
</style>
</body>

</html><?php /**PATH C:\wamp64\www\olshop\resources\views/components/layouts/app.blade.php ENDPATH**/ ?>